!macro CustomCodePreInstall
	;Determine version of opera that will be run
	${If} ${FileExists} "$INSTDIR\App\Opera\launcher.exe"
		MoreInfo::GetProductVersion "$INSTDIR\App\Opera\launcher.exe"
		Pop $0
		${If} ${FileExists} "$INSTDIR\App\Opera\$0\resources\custom_partner_content.json"
			Rename "$INSTDIR\App\Opera\$0\resources\custom_partner_content.json" "$INSTDIR\Data\custom_partner_content.json"
		${EndIf}
	${EndIf}
	
	${If} ${FileExists} "$INSTDIR\App\Opera\profile\data\Crash Reports\*.*"
	${AndIfNot} ${FileExists} "$INSTDIR\App\Opera\profile\data\preferences"
		RMDir /r "$INSTDIR\App\Opera\profile"
	${EndIf}
	
	${If} ${FileExists} "$INSTDIR\App\AppInfo\appinfo.ini"
		ReadINIStr $0 "$INSTDIR\App\AppInfo\appinfo.ini" "Version" "PackageVersion"
		${VersionCompare} $0 "96.0.0.0" $R0
		${If} $R0 == 2
			ReadRegStr $1 HKLM "Software\Microsoft\Windows NT\CurrentVersion" "CurrentBuild"
			${If} $1 < 10000 ;Windows 7/8/8.1
				${GetParent} $INSTDIR $1
				CreateDirectory "$1\OperaPortableLegacyWin7"
				CopyFiles /SILENT "$INSTDIR\*.*" "$1\OperaPortableLegacyWin7"
				WriteINIStr "$1\OperaPortableLegacyWin7\App\AppInfo\AppInfo.ini" "Details" "AppID" "OperaPortableLegacyWin7"
				WriteINIStr "$1\OperaPortableLegacyWin7\App\AppInfo\AppInfo.ini" "Details" "Name" "Opera, Portable Edition (Legacy Win7)"
			${EndIf}
		${EndIf}
	${EndIf}
!macroend

!macro CustomCodePostInstall
	;Determine version of opera that will be run
	${If} ${FileExists} "$INSTDIR\App\Opera\launcher.exe"
		MoreInfo::GetProductVersion "$INSTDIR\App\Opera\launcher.exe"
		Pop $0
		${If} ${FileExists} "$INSTDIR\Data\custom_partner_content.json"
			Rename "$INSTDIR\Data\custom_partner_content.json" "$INSTDIR\App\Opera\$0\resources\custom_partner_content.json"
		${EndIf}
	${EndIf}
!macroend